/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.message;

import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.toolkit.designer.message.resources.VWSIMResource;

class VWSIMValidationToolTip {
    private static final int MAX_TOOLTIP_WIDTH = 80;

    public static String createValidationToolTip(VWScenarioValidationError error) {
        String tooltip = null;
        int errorLevel = error.getLevel();
        int errorType = error.getErrorType();
        String name = error.getName();
        String message = error.getMessage();
        String info = error.getInfo();
        if (name != null || message != null || info != null) {
            String errorLevelString = VWSIMValidationToolTip.getErrorLevelString(errorLevel);
            String errorTypeString = VWSIMValidationToolTip.getErrorTypeString(error);
            String nameString = VWSIMValidationToolTip.getNameString(name);
            String messageString = VWSIMValidationToolTip.getMessageString(message);
            String infoString = VWSIMValidationToolTip.getInfoString(info);
            tooltip = "<html>" + errorLevelString + errorTypeString + nameString + messageString + infoString + "</html>";
        }
        return tooltip;
    }

    private static String getErrorSubtypeString(int errorType) {
        String errorSubtypeString = null;
        switch (errorType) {
            case 7: {
                break;
            }
            case 3: {
                errorSubtypeString = VWSIMResource.s_resource;
                break;
            }
            case 4: {
                errorSubtypeString = VWSIMResource.s_jobDuty;
                break;
            }
            case 5: {
                errorSubtypeString = VWSIMResource.s_shift;
                break;
            }
            case 8: {
                errorSubtypeString = VWSIMResource.s_step;
                break;
            }
            case 6: {
                errorSubtypeString = VWSIMResource.s_workflow;
                break;
            }
            case 2: {
                errorSubtypeString = VWSIMResource.s_general;
            }
        }
        return errorSubtypeString;
    }

    private static String getErrorLevelString(int errorLevel) {
        String errorLevelString = null;
        switch (errorLevel) {
            case 1: {
                errorLevelString = VWSIMResource.s_error;
                break;
            }
            case 2: {
                errorLevelString = VWSIMResource.s_warning;
            }
        }
        errorLevelString = "<B>" + errorLevelString + "</B>";
        return errorLevelString;
    }

    private static String getErrorTypeString(VWScenarioValidationError error) {
        String errorTypeString = null;
        int errorType = error.getErrorType();
        switch (errorType) {
            case 1: {
                errorTypeString = VWSIMResource.s_workflow;
                break;
            }
            default: {
                errorTypeString = VWSIMResource.s_scenario;
                String subType = VWSIMValidationToolTip.getErrorSubtypeString(errorType);
                if (subType == null) break;
                errorTypeString = errorTypeString + " - " + subType;
            }
        }
        errorTypeString = "<B>" + VWSIMResource.s_errorType + "</B> " + errorTypeString + "<BR>";
        return errorTypeString;
    }

    private static String getNameString(String name) {
        String nameString = null;
        nameString = "<B>" + VWSIMResource.s_nameColon + "</B> " + VWSIMValidationToolTip.formatLongString(name) + "<BR>";
        return nameString;
    }

    private static String getMessageString(String message) {
        String messageString = null;
        messageString = "<B>" + VWSIMResource.s_messageColon + "</B> " + VWSIMValidationToolTip.formatLongString(message) + "<BR>";
        return messageString;
    }

    private static String getInfoString(String info) {
        String infoString = null;
        infoString = "<B>" + VWSIMResource.s_informationColon + "</B> " + VWSIMValidationToolTip.formatLongString(info);
        return infoString;
    }

    private static String formatLongString(String longStr) {
        String formatString = "";
        if (longStr != null) {
            if (longStr.length() <= 80) {
                formatString = longStr;
            } else {
                String tempString = longStr;
                while (tempString.length() > 80) {
                    formatString = formatString + tempString.substring(0, 79) + "<BR>";
                    tempString = tempString.substring(80, tempString.length());
                }
                formatString = formatString + tempString;
            }
        }
        return formatString;
    }
}

